#include <iostream>
#include <vector>
#include <cmath>
#include <unordered_map>

using namespace std;
using ul = unsigned long;

ul A[1048578];

class Stablo {
public:
    Stablo(ul N) {
        level = log2(N);
        stablo.resize(level);
        for (ul i = 0; i < level; i++) {
            stablo[i].resize(pow(2, level - i), 0);
        }
    }

    // Copy constructor
    Stablo(const Stablo& other) {
        level = other.level;
        stablo = other.stablo;
    }
    Stablo& operator=(const Stablo& other) {
        if (this != &other) {
            level = other.level;
            stablo = other.stablo; 
        }
        return *this;
    }

    void update(ul index) {

        for (ul i = 0; i < level; i++) {
            ul block = index / (1 << i);
            stablo[i][block]++;
        }
    }

    vector<vector<ul>> stablo;
    ul level;
};

int main() {
    ul N;
    cin >> N;
    
    unordered_map<ul, ul> mapa;
    for (ul i = 0; i < N; i++) {
        cin >> A[i];
        mapa[A[i]] = i;
    }

    vector<Stablo> stabla(N + 1, Stablo(N));
    for (ul i = 1; i <= N; i++) {
        ul index = mapa[i];
        stabla[i] = stabla[i - 1];
        stabla[i].update(index);
    }
    
    ul M,J,Q, Snaga, level_sposobnost, level_doguran;
    cin >> Q;
    for(ul q=0;q<Q;q++){
        cin >> M >> J;
        M--;
        Snaga = A[M];
        level_doguran = 1;
        level_sposobnost = static_cast<ul>(log2(Snaga)) + 1;
        bool paran;
        for(ul i = 1; i < level_sposobnost;i++){
            paran=M%2;
            M = paran ?M-1:M+1;
            if(J - (pow(2,i-1) -stabla[Snaga-1].stablo[i-1][M] )  >= 0){
                J-=(pow(2,i-1) -stabla[Snaga-1].stablo[i-1][M] );
                level_doguran++;
            }
            else{
                break;
            }
            
            M/=2;
        }
       cout << level_doguran  << "\n"; 
    }
    
    return 0;
}